/*
 * Decompiled with CFR 0.152.
 */
package com.slimjars.dist.gnu.trove.map.hash;

import com.slimjars.dist.gnu.trove.TByteCollection;
import com.slimjars.dist.gnu.trove.TFloatCollection;
import com.slimjars.dist.gnu.trove.function.TFloatFunction;
import com.slimjars.dist.gnu.trove.impl.HashFunctions;
import com.slimjars.dist.gnu.trove.impl.hash.TByteFloatHash;
import com.slimjars.dist.gnu.trove.impl.hash.THashPrimitiveIterator;
import com.slimjars.dist.gnu.trove.impl.hash.TPrimitiveHash;
import com.slimjars.dist.gnu.trove.iterator.TByteFloatIterator;
import com.slimjars.dist.gnu.trove.iterator.TByteIterator;
import com.slimjars.dist.gnu.trove.iterator.TFloatIterator;
import com.slimjars.dist.gnu.trove.map.TByteFloatMap;
import com.slimjars.dist.gnu.trove.procedure.TByteFloatProcedure;
import com.slimjars.dist.gnu.trove.procedure.TByteProcedure;
import com.slimjars.dist.gnu.trove.procedure.TFloatProcedure;
import com.slimjars.dist.gnu.trove.set.TByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TByteFloatHashMap
extends TByteFloatHash
implements TByteFloatMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient float[] _values;

    public TByteFloatHashMap() {
    }

    public TByteFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteFloatHashMap(int initialCapacity, float loadFactor, byte noEntryKey, float noEntryValue) {
        super(initialCapacity, loadFactor, noEntryKey, noEntryValue);
    }

    public TByteFloatHashMap(byte[] keys, float[] values) {
        super(Math.max(keys.length, values.length));
        int size = Math.min(keys.length, values.length);
        for (int i = 0; i < size; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public TByteFloatHashMap(TByteFloatMap map) {
        super(map.size());
        if (map instanceof TByteFloatHashMap) {
            TByteFloatHashMap hashmap = (TByteFloatHashMap)map;
            this._loadFactor = Math.abs(hashmap._loadFactor);
            this.no_entry_key = hashmap.no_entry_key;
            this.no_entry_value = hashmap.no_entry_value;
            if (this.no_entry_key != 0) {
                Arrays.fill(this._set, this.no_entry_key);
            }
            if (this.no_entry_value != 0.0f) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp(TByteFloatHashMap.saturatedCast((long)TByteFloatHashMap.fastCeil((double)(10.0 / (double)this._loadFactor))));
        }
        this.putAll(map);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new float[capacity];
        return capacity;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        byte[] oldKeys = this._set;
        float[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._values = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            byte o = oldKeys[i];
            int index = this.insertKey(o);
            this._values[index] = oldVals[i];
        }
    }

    public float put(byte key, float value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    public float putIfAbsent(byte key, float value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values[-index - 1];
        }
        return this.doPut(key, value, index);
    }

    private float doPut(byte key, float value, int index) {
        float previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    public void putAll(Map<? extends Byte, ? extends Float> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Byte, ? extends Float> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue().floatValue());
        }
    }

    public void putAll(TByteFloatMap map) {
        this.ensureCapacity(map.size());
        TByteFloatIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    public float get(byte key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values[index];
    }

    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public float remove(byte key) {
        float prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    protected void removeAt(int index) {
        this._values[index] = this.no_entry_value;
        super.removeAt(index);
    }

    public TByteSet keySet() {
        return new TKeyView();
    }

    public byte[] keys() {
        byte[] keys = new byte[this.size()];
        if (keys.length == 0) {
            return keys;
        }
        byte[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public byte[] keys(byte[] array) {
        int size = this.size();
        if (size == 0) {
            return array;
        }
        if (array.length < size) {
            array = new byte[size];
        }
        byte[] keys = this._set;
        byte[] states = this._states;
        int i = keys.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            array[j++] = keys[i];
        }
        return array;
    }

    public TFloatCollection valueCollection() {
        return new TValueView();
    }

    public float[] values() {
        float[] vals = new float[this.size()];
        if (vals.length == 0) {
            return vals;
        }
        float[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public float[] values(float[] array) {
        int size = this.size();
        if (size == 0) {
            return array;
        }
        if (array.length < size) {
            array = new float[size];
        }
        float[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            array[j++] = v[i];
        }
        return array;
    }

    public boolean containsValue(float val) {
        byte[] states = this._states;
        float[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(byte key) {
        return this.contains(key);
    }

    public TByteFloatIterator iterator() {
        return new TByteFloatHashIterator(this);
    }

    public boolean forEachKey(TByteProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TByteFloatProcedure procedure) {
        byte[] states = this._states;
        byte[] keys = this._set;
        float[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TFloatFunction function) {
        byte[] states = this._states;
        float[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TByteFloatProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        byte[] keys = this._set;
        float[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public boolean increment(byte key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(byte key, float amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    public float adjustOrPutValue(byte key, float adjust_amount, float put_amount) {
        boolean isNewMapping;
        float newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            int n = index = -index - 1;
            float f = this._values[n] + adjust_amount;
            this._values[n] = f;
            newValue = f;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index];
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteFloatMap)) {
            return false;
        }
        TByteFloatMap that = (TByteFloatMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        float[] values = this._values;
        byte[] states = this._states;
        float this_no_entry_value = this.getNoEntryValue();
        float that_no_entry_value = that.getNoEntryValue();
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            byte key = this._set[i];
            if (!that.containsKey(key)) {
                return false;
            }
            float this_value = values[i];
            float that_value = that.get(key);
            if (this_value == that_value || this_value == this_no_entry_value && that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        byte[] states = this._states;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            hashcode += HashFunctions.hash((int)this._set[i]) ^ HashFunctions.hash((float)this._values[i]);
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TByteFloatProcedure(){
            private boolean first = true;

            public boolean execute(byte key, float value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this._states.length;
        while (i-- > 0) {
            if (this._states[i] != 1) continue;
            out.writeByte(this._set[i]);
            out.writeFloat(this._values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte key = in.readByte();
            float val = in.readFloat();
            this.put(key, val);
        }
    }

    class TByteFloatHashIterator
    extends THashPrimitiveIterator
    implements TByteFloatIterator {
        TByteFloatHashIterator(TByteFloatHashMap map) {
            super((TPrimitiveHash)map);
        }

        public void advance() {
            this.moveToNextIndex();
        }

        public byte key() {
            return TByteFloatHashMap.this._set[this._index];
        }

        public float value() {
            return TByteFloatHashMap.this._values[this._index];
        }

        public float setValue(float val) {
            float old = this.value();
            TByteFloatHashMap.this._values[this._index] = val;
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TByteFloatHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TByteFloatValueHashIterator
    extends THashPrimitiveIterator
    implements TFloatIterator {
        TByteFloatValueHashIterator(TPrimitiveHash hash) {
            super(hash);
        }

        public float next() {
            this.moveToNextIndex();
            return TByteFloatHashMap.this._values[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TByteFloatHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TByteFloatKeyHashIterator
    extends THashPrimitiveIterator
    implements TByteIterator {
        TByteFloatKeyHashIterator(TPrimitiveHash hash) {
            super(hash);
        }

        public byte next() {
            this.moveToNextIndex();
            return TByteFloatHashMap.this._set[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TByteFloatHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TValueView
    implements TFloatCollection {
        protected TValueView() {
        }

        public TFloatIterator iterator() {
            return new TByteFloatValueHashIterator((TPrimitiveHash)TByteFloatHashMap.this);
        }

        public float getNoEntryValue() {
            return TByteFloatHashMap.this.no_entry_value;
        }

        public int size() {
            return TByteFloatHashMap.this._size;
        }

        public boolean isEmpty() {
            return 0 == TByteFloatHashMap.this._size;
        }

        public boolean contains(float entry) {
            return TByteFloatHashMap.this.containsValue(entry);
        }

        public float[] toArray() {
            return TByteFloatHashMap.this.values();
        }

        public float[] toArray(float[] dest) {
            return TByteFloatHashMap.this.values(dest);
        }

        public boolean add(float entry) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float entry) {
            float[] values = TByteFloatHashMap.this._values;
            byte[] states = TByteFloatHashMap.this._states;
            int i = values.length;
            while (i-- > 0) {
                if (states[i] == 0 || states[i] == 2 || entry != values[i]) continue;
                TByteFloatHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Float) {
                    float ele = ((Float)element).floatValue();
                    if (TByteFloatHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        public boolean containsAll(TFloatCollection collection) {
            TFloatIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TByteFloatHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(float[] array) {
            for (float element : array) {
                if (TByteFloatHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection<? extends Float> collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(TFloatCollection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float[] array) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TFloatIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(Float.valueOf(iter.next()))) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(TFloatCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TFloatIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(float[] array) {
            boolean changed = false;
            Arrays.sort(array);
            float[] values = TByteFloatHashMap.this._values;
            byte[] states = TByteFloatHashMap.this._states;
            int i = values.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, values[i]) >= 0) continue;
                TByteFloatHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                float c;
                if (!(element instanceof Float) || !this.remove(c = ((Float)element).floatValue())) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(TFloatCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            for (float element : collection) {
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(float[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        public void clear() {
            TByteFloatHashMap.this.clear();
        }

        public boolean forEach(TFloatProcedure procedure) {
            return TByteFloatHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TByteFloatHashMap.this.forEachValue(new TFloatProcedure(){
                private boolean first = true;

                public boolean execute(float value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TKeyView
    implements TByteSet {
        protected TKeyView() {
        }

        public TByteIterator iterator() {
            return new TByteFloatKeyHashIterator((TPrimitiveHash)TByteFloatHashMap.this);
        }

        public byte getNoEntryValue() {
            return TByteFloatHashMap.this.no_entry_key;
        }

        public int size() {
            return TByteFloatHashMap.this._size;
        }

        public boolean isEmpty() {
            return 0 == TByteFloatHashMap.this._size;
        }

        public boolean contains(byte entry) {
            return TByteFloatHashMap.this.contains(entry);
        }

        public byte[] toArray() {
            return TByteFloatHashMap.this.keys();
        }

        public byte[] toArray(byte[] dest) {
            return TByteFloatHashMap.this.keys(dest);
        }

        public boolean add(byte entry) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte entry) {
            return TByteFloatHashMap.this.no_entry_value != TByteFloatHashMap.this.remove(entry);
        }

        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Byte) {
                    byte ele = (Byte)element;
                    if (TByteFloatHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        public boolean containsAll(TByteCollection collection) {
            TByteIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TByteFloatHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(byte[] array) {
            for (byte element : array) {
                if (TByteFloatHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection<? extends Byte> collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(TByteCollection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte[] array) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TByteIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(TByteCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TByteIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(byte[] array) {
            boolean changed = false;
            Arrays.sort(array);
            byte[] set = TByteFloatHashMap.this._set;
            byte[] states = TByteFloatHashMap.this._states;
            int i = set.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
                TByteFloatHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                byte c;
                if (!(element instanceof Byte) || !this.remove(c = ((Byte)element).byteValue())) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(TByteCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            for (byte element : collection) {
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(byte[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        public void clear() {
            TByteFloatHashMap.this.clear();
        }

        public boolean forEach(TByteProcedure procedure) {
            return TByteFloatHashMap.this.forEachKey(procedure);
        }

        public boolean equals(Object other) {
            if (!(other instanceof TByteSet)) {
                return false;
            }
            TByteSet that = (TByteSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TByteFloatHashMap.this._states.length;
            while (i-- > 0) {
                if (TByteFloatHashMap.this._states[i] != 1 || that.contains(TByteFloatHashMap.this._set[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashcode = 0;
            int i = TByteFloatHashMap.this._states.length;
            while (i-- > 0) {
                if (TByteFloatHashMap.this._states[i] != 1) continue;
                hashcode += HashFunctions.hash((int)TByteFloatHashMap.this._set[i]);
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TByteFloatHashMap.this.forEachKey(new TByteProcedure(){
                private boolean first = true;

                public boolean execute(byte key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

