/*
 * Decompiled with CFR 0.152.
 */
package com.slimjars.dist.gnu.trove.set.hash;

import com.slimjars.dist.gnu.trove.impl.hash.TObjectHash;
import com.slimjars.dist.gnu.trove.iterator.TIntIterator;
import com.slimjars.dist.gnu.trove.iterator.hash.TObjectHashIterator;
import com.slimjars.dist.gnu.trove.list.TIntList;
import com.slimjars.dist.gnu.trove.list.array.TIntArrayList;
import com.slimjars.dist.gnu.trove.list.linked.TIntLinkedList;
import com.slimjars.dist.gnu.trove.procedure.TIntProcedure;
import com.slimjars.dist.gnu.trove.procedure.TObjectProcedure;
import com.slimjars.dist.gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLinkedHashSet<E>
extends THashSet<E> {
    TIntList order;

    public TLinkedHashSet() {
    }

    public TLinkedHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TLinkedHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TLinkedHashSet(Collection<? extends E> es) {
        super(es);
    }

    public int setUp(int initialCapacity) {
        this.order = new TIntArrayList(initialCapacity){

            public void ensureCapacity(int capacity) {
                if (capacity > this._data.length) {
                    int newCap = Math.max(TLinkedHashSet.this._set.length, capacity);
                    int[] tmp = new int[newCap];
                    System.arraycopy(this._data, 0, tmp, 0, this._data.length);
                    this._data = tmp;
                }
            }
        };
        return super.setUp(initialCapacity);
    }

    public void clear() {
        super.clear();
        this.order.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        boolean first = true;
        TObjectHashIterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(it.next());
        }
        buf.append("}");
        return buf.toString();
    }

    public boolean add(E obj) {
        int index = this.insertKey(obj);
        if (index < 0) {
            return false;
        }
        if (!this.order.add(index)) {
            throw new IllegalStateException("Order not changed after insert");
        }
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    protected void removeAt(int index) {
        this.order.remove(index);
        super.removeAt(index);
    }

    protected void rehash(int newCapacity) {
        TIntLinkedList oldOrder = new TIntLinkedList(this.order);
        int oldSize = this.size();
        Object[] oldSet = this._set;
        this.order.clear();
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        for (int i : oldOrder) {
            Object o = oldSet[i];
            if (o == FREE || o == REMOVED) {
                throw new IllegalStateException("Iterating over empty location while rehashing");
            }
            if (o == FREE || o == REMOVED) continue;
            int index = this.insertKey(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o, this.size(), oldSize, oldSet);
            }
            if (this.order.add(index)) continue;
            throw new IllegalStateException("Order not changed after insert");
        }
    }

    protected void writeEntries(ObjectOutput out) throws IOException {
        WriteProcedure writeProcedure = new WriteProcedure(out);
        if (!this.order.forEach((TIntProcedure)writeProcedure)) {
            throw writeProcedure.getIoException();
        }
    }

    public TObjectHashIterator<E> iterator() {
        return new TObjectHashIterator<E>((TObjectHash)this){
            TIntIterator localIterator;
            int lastIndex;
            {
                this.localIterator = TLinkedHashSet.this.order.iterator();
            }

            public E next() {
                this.lastIndex = this.localIterator.next();
                return this.objectAtIndex(this.lastIndex);
            }

            public boolean hasNext() {
                return this.localIterator.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                this.localIterator.remove();
                try {
                    this._hash.tempDisableAutoCompaction();
                    TLinkedHashSet.this.removeAt(this.lastIndex);
                }
                finally {
                    this._hash.reenableAutoCompaction(false);
                }
            }
        };
    }

    public boolean forEach(TObjectProcedure<? super E> procedure) {
        ForEachProcedure forEachProcedure = new ForEachProcedure(this._set, procedure);
        return this.order.forEach((TIntProcedure)forEachProcedure);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ForEachProcedure
    implements TIntProcedure {
        boolean changed = false;
        final Object[] set;
        final TObjectProcedure<? super E> procedure;

        public ForEachProcedure(Object[] set, TObjectProcedure<? super E> procedure) {
            this.set = set;
            this.procedure = procedure;
        }

        public boolean execute(int value) {
            return this.procedure.execute(this.set[value]);
        }
    }

    class WriteProcedure
    implements TIntProcedure {
        final ObjectOutput output;
        IOException ioException;

        WriteProcedure(ObjectOutput output) {
            this.output = output;
        }

        public IOException getIoException() {
            return this.ioException;
        }

        public boolean execute(int value) {
            try {
                this.output.writeObject(TLinkedHashSet.this._set[value]);
            }
            catch (IOException e) {
                this.ioException = e;
                return false;
            }
            return true;
        }
    }
}

