/*
 * Decompiled with CFR 0.152.
 */
package com.slimjars.dist.gnu.trove.map.hash;

import com.slimjars.dist.gnu.trove.TByteCollection;
import com.slimjars.dist.gnu.trove.TShortCollection;
import com.slimjars.dist.gnu.trove.function.TByteFunction;
import com.slimjars.dist.gnu.trove.impl.HashFunctions;
import com.slimjars.dist.gnu.trove.impl.hash.THashPrimitiveIterator;
import com.slimjars.dist.gnu.trove.impl.hash.TPrimitiveHash;
import com.slimjars.dist.gnu.trove.impl.hash.TShortByteHash;
import com.slimjars.dist.gnu.trove.iterator.TByteIterator;
import com.slimjars.dist.gnu.trove.iterator.TShortByteIterator;
import com.slimjars.dist.gnu.trove.iterator.TShortIterator;
import com.slimjars.dist.gnu.trove.map.TShortByteMap;
import com.slimjars.dist.gnu.trove.procedure.TByteProcedure;
import com.slimjars.dist.gnu.trove.procedure.TShortByteProcedure;
import com.slimjars.dist.gnu.trove.procedure.TShortProcedure;
import com.slimjars.dist.gnu.trove.set.TShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortByteHashMap
extends TShortByteHash
implements TShortByteMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient byte[] _values;

    public TShortByteHashMap() {
    }

    public TShortByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TShortByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TShortByteHashMap(int initialCapacity, float loadFactor, short noEntryKey, byte noEntryValue) {
        super(initialCapacity, loadFactor, noEntryKey, noEntryValue);
    }

    public TShortByteHashMap(short[] keys, byte[] values) {
        super(Math.max(keys.length, values.length));
        int size = Math.min(keys.length, values.length);
        for (int i = 0; i < size; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public TShortByteHashMap(TShortByteMap map) {
        super(map.size());
        if (map instanceof TShortByteHashMap) {
            TShortByteHashMap hashmap = (TShortByteHashMap)map;
            this._loadFactor = Math.abs(hashmap._loadFactor);
            this.no_entry_key = hashmap.no_entry_key;
            this.no_entry_value = hashmap.no_entry_value;
            if (this.no_entry_key != 0) {
                Arrays.fill(this._set, this.no_entry_key);
            }
            if (this.no_entry_value != 0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp(TShortByteHashMap.saturatedCast((long)TShortByteHashMap.fastCeil((double)(10.0 / (double)this._loadFactor))));
        }
        this.putAll(map);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new byte[capacity];
        return capacity;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        short[] oldKeys = this._set;
        byte[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new short[newCapacity];
        this._values = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            short o = oldKeys[i];
            int index = this.insertKey(o);
            this._values[index] = oldVals[i];
        }
    }

    public byte put(short key, byte value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    public byte putIfAbsent(short key, byte value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values[-index - 1];
        }
        return this.doPut(key, value, index);
    }

    private byte doPut(short key, byte value, int index) {
        byte previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    public void putAll(Map<? extends Short, ? extends Byte> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Short, ? extends Byte> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(TShortByteMap map) {
        this.ensureCapacity(map.size());
        TShortByteIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    public byte get(short key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values[index];
    }

    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public byte remove(short key) {
        byte prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    protected void removeAt(int index) {
        this._values[index] = this.no_entry_value;
        super.removeAt(index);
    }

    public TShortSet keySet() {
        return new TKeyView();
    }

    public short[] keys() {
        short[] keys = new short[this.size()];
        if (keys.length == 0) {
            return keys;
        }
        short[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public short[] keys(short[] array) {
        int size = this.size();
        if (size == 0) {
            return array;
        }
        if (array.length < size) {
            array = new short[size];
        }
        short[] keys = this._set;
        byte[] states = this._states;
        int i = keys.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            array[j++] = keys[i];
        }
        return array;
    }

    public TByteCollection valueCollection() {
        return new TValueView();
    }

    public byte[] values() {
        byte[] vals = new byte[this.size()];
        if (vals.length == 0) {
            return vals;
        }
        byte[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public byte[] values(byte[] array) {
        int size = this.size();
        if (size == 0) {
            return array;
        }
        if (array.length < size) {
            array = new byte[size];
        }
        byte[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            array[j++] = v[i];
        }
        return array;
    }

    public boolean containsValue(byte val) {
        byte[] states = this._states;
        byte[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(short key) {
        return this.contains(key);
    }

    public TShortByteIterator iterator() {
        return new TShortByteHashIterator(this);
    }

    public boolean forEachKey(TShortProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TShortByteProcedure procedure) {
        byte[] states = this._states;
        short[] keys = this._set;
        byte[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TByteFunction function) {
        byte[] states = this._states;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TShortByteProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        short[] keys = this._set;
        byte[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public boolean increment(short key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(short key, byte amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    public byte adjustOrPutValue(short key, byte adjust_amount, byte put_amount) {
        boolean isNewMapping;
        byte newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            int n = index = -index - 1;
            byte by = (byte)(this._values[n] + adjust_amount);
            this._values[n] = by;
            newValue = by;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index];
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TShortByteMap)) {
            return false;
        }
        TShortByteMap that = (TShortByteMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        byte[] values = this._values;
        byte[] states = this._states;
        byte this_no_entry_value = this.getNoEntryValue();
        byte that_no_entry_value = that.getNoEntryValue();
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            short key = this._set[i];
            if (!that.containsKey(key)) {
                return false;
            }
            byte this_value = values[i];
            byte that_value = that.get(key);
            if (this_value == that_value || this_value == this_no_entry_value && that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        byte[] states = this._states;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            hashcode += HashFunctions.hash((int)this._set[i]) ^ HashFunctions.hash((int)this._values[i]);
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TShortByteProcedure(){
            private boolean first = true;

            public boolean execute(short key, byte value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this._states.length;
        while (i-- > 0) {
            if (this._states[i] != 1) continue;
            out.writeShort(this._set[i]);
            out.writeByte(this._values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            short key = in.readShort();
            byte val = in.readByte();
            this.put(key, val);
        }
    }

    class TShortByteHashIterator
    extends THashPrimitiveIterator
    implements TShortByteIterator {
        TShortByteHashIterator(TShortByteHashMap map) {
            super((TPrimitiveHash)map);
        }

        public void advance() {
            this.moveToNextIndex();
        }

        public short key() {
            return TShortByteHashMap.this._set[this._index];
        }

        public byte value() {
            return TShortByteHashMap.this._values[this._index];
        }

        public byte setValue(byte val) {
            byte old = this.value();
            TShortByteHashMap.this._values[this._index] = val;
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortByteHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TShortByteValueHashIterator
    extends THashPrimitiveIterator
    implements TByteIterator {
        TShortByteValueHashIterator(TPrimitiveHash hash) {
            super(hash);
        }

        public byte next() {
            this.moveToNextIndex();
            return TShortByteHashMap.this._values[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortByteHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TShortByteKeyHashIterator
    extends THashPrimitiveIterator
    implements TShortIterator {
        TShortByteKeyHashIterator(TPrimitiveHash hash) {
            super(hash);
        }

        public short next() {
            this.moveToNextIndex();
            return TShortByteHashMap.this._set[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortByteHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TValueView
    implements TByteCollection {
        protected TValueView() {
        }

        public TByteIterator iterator() {
            return new TShortByteValueHashIterator((TPrimitiveHash)TShortByteHashMap.this);
        }

        public byte getNoEntryValue() {
            return TShortByteHashMap.this.no_entry_value;
        }

        public int size() {
            return TShortByteHashMap.this._size;
        }

        public boolean isEmpty() {
            return 0 == TShortByteHashMap.this._size;
        }

        public boolean contains(byte entry) {
            return TShortByteHashMap.this.containsValue(entry);
        }

        public byte[] toArray() {
            return TShortByteHashMap.this.values();
        }

        public byte[] toArray(byte[] dest) {
            return TShortByteHashMap.this.values(dest);
        }

        public boolean add(byte entry) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte entry) {
            byte[] values = TShortByteHashMap.this._values;
            byte[] states = TShortByteHashMap.this._states;
            int i = values.length;
            while (i-- > 0) {
                if (states[i] == 0 || states[i] == 2 || entry != values[i]) continue;
                TShortByteHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Byte) {
                    byte ele = (Byte)element;
                    if (TShortByteHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        public boolean containsAll(TByteCollection collection) {
            TByteIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TShortByteHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(byte[] array) {
            for (byte element : array) {
                if (TShortByteHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection<? extends Byte> collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(TByteCollection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte[] array) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TByteIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(TByteCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TByteIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(byte[] array) {
            boolean changed = false;
            Arrays.sort(array);
            byte[] values = TShortByteHashMap.this._values;
            byte[] states = TShortByteHashMap.this._states;
            int i = values.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, values[i]) >= 0) continue;
                TShortByteHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                byte c;
                if (!(element instanceof Byte) || !this.remove(c = ((Byte)element).byteValue())) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(TByteCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            for (byte element : collection) {
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(byte[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        public void clear() {
            TShortByteHashMap.this.clear();
        }

        public boolean forEach(TByteProcedure procedure) {
            return TShortByteHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TShortByteHashMap.this.forEachValue(new TByteProcedure(){
                private boolean first = true;

                public boolean execute(byte value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TKeyView
    implements TShortSet {
        protected TKeyView() {
        }

        public TShortIterator iterator() {
            return new TShortByteKeyHashIterator((TPrimitiveHash)TShortByteHashMap.this);
        }

        public short getNoEntryValue() {
            return TShortByteHashMap.this.no_entry_key;
        }

        public int size() {
            return TShortByteHashMap.this._size;
        }

        public boolean isEmpty() {
            return 0 == TShortByteHashMap.this._size;
        }

        public boolean contains(short entry) {
            return TShortByteHashMap.this.contains(entry);
        }

        public short[] toArray() {
            return TShortByteHashMap.this.keys();
        }

        public short[] toArray(short[] dest) {
            return TShortByteHashMap.this.keys(dest);
        }

        public boolean add(short entry) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(short entry) {
            return TShortByteHashMap.this.no_entry_value != TShortByteHashMap.this.remove(entry);
        }

        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Short) {
                    short ele = (Short)element;
                    if (TShortByteHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        public boolean containsAll(TShortCollection collection) {
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TShortByteHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(short[] array) {
            for (short element : array) {
                if (TShortByteHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection<? extends Short> collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(TShortCollection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(short[] array) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(TShortCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        public boolean retainAll(short[] array) {
            boolean changed = false;
            Arrays.sort(array);
            short[] set = TShortByteHashMap.this._set;
            byte[] states = TShortByteHashMap.this._states;
            int i = set.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
                TShortByteHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                short c;
                if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(TShortCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            for (short element : collection) {
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        public boolean removeAll(short[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        public void clear() {
            TShortByteHashMap.this.clear();
        }

        public boolean forEach(TShortProcedure procedure) {
            return TShortByteHashMap.this.forEachKey(procedure);
        }

        public boolean equals(Object other) {
            if (!(other instanceof TShortSet)) {
                return false;
            }
            TShortSet that = (TShortSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TShortByteHashMap.this._states.length;
            while (i-- > 0) {
                if (TShortByteHashMap.this._states[i] != 1 || that.contains(TShortByteHashMap.this._set[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashcode = 0;
            int i = TShortByteHashMap.this._states.length;
            while (i-- > 0) {
                if (TShortByteHashMap.this._states[i] != 1) continue;
                hashcode += HashFunctions.hash((int)TShortByteHashMap.this._set[i]);
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TShortByteHashMap.this.forEachKey(new TShortProcedure(){
                private boolean first = true;

                public boolean execute(short key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

